/*
 * Decompiled with CFR 0.152.
 */
package jace;

import jace.EmulatorUILogic;
import jace.apple2e.Apple2e;
import jace.config.Configuration;
import jace.core.Computer;
import jace.ui.AbstractEmulatorFrame;
import jace.ui.EmulatorFrame;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class Emulator {
    public static Emulator instance;
    public static Thread mainThread;
    public Apple2e computer = new Apple2e();
    public AbstractEmulatorFrame theApp;

    public static void main(String ... args) {
        mainThread = Thread.currentThread();
        instance = new Emulator(args);
    }

    public static AbstractEmulatorFrame getFrame() {
        if (instance != null) {
            return Emulator.instance.theApp;
        }
        return null;
    }

    public Emulator(String ... args) {
        Configuration.loadSettings();
        HashMap<String, String> settings = new HashMap<String, String>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    String key = args[i].substring(1);
                    if (i + 1 < args.length) {
                        String val = args[i + 1];
                        if (!val.startsWith("-")) {
                            settings.put(key, val);
                            ++i;
                            continue;
                        }
                        settings.put(key, "true");
                        continue;
                    }
                    settings.put(key, "true");
                    continue;
                }
                System.err.println("Did not understand parameter " + args[i] + ", skipping.");
            }
        }
        Configuration.applySettings(settings);
        this.theApp = new EmulatorFrame();
        try {
            this.theApp.setIconImage(ImageIO.read(Emulator.class.getClassLoader().getResourceAsStream("jace/data/woz_figure.gif")));
        }
        catch (IOException ex) {
            Logger.getLogger(Emulator.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.theApp.setVisible(true);
        this.theApp.setDefaultCloseOperation(3);
        this.theApp.setFocusTraversalKeysEnabled(false);
        this.theApp.setTitle("Java Apple Computer Emulator");
        this.theApp.addKeyListener(this.computer.getKeyboard().getListener());
        this.theApp.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Emulator.resizeVideo();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Emulator.resizeVideo();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.theApp.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
                Computer.getComputer().getVideo().suspend();
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                Computer.getComputer().getVideo().resume();
                Emulator.resizeVideo();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                Emulator.resizeVideo();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                Emulator.resizeVideo();
            }
        });
        EmulatorUILogic.registerDebugger();
        this.computer.getVideo().setScreen(this.theApp.getScreenGraphics());
        this.computer.coldStart();
    }

    public static void resizeVideo() {
        AbstractEmulatorFrame window = Emulator.getFrame();
        if (window != null) {
            window.resizeVideo();
        }
    }

    public static Component getScreen() {
        AbstractEmulatorFrame window = Emulator.getFrame();
        if (window != null) {
            return window.getScreen();
        }
        return null;
    }
}

